<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
/**
 *
 * Gallery Widget .
 *
 */
class Traga_Gallery extends Widget_Base{

	public function get_name() {
		return 'tragagallery';
	}

	public function get_title() {
		return __( 'Webteck Gallery', 'webteck' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'gallery_section',
			[
				'label' 	=> __( 'Gallery', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);
		//----------------------------feddback repeter start--------------------------------//

		$repeater = new Repeater();
        $repeater->add_control(
			'gallery_image',
			[
				'label' 		=> __( 'Gallery Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'repeater_list',
			[
				'label' 		=> __( 'Images', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'gallery_image'    => ['url'=> Utils::get_placeholder_image_src()]
					],
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<div class="row gy-4">';
			foreach( $settings['repeater_list'] as $single_data ){
				echo '<div class="col-md-6 col-xl-4">';
					echo '<div class="gallery-card">';
						echo '<div class="gallery-img">';
							echo webteck_img_tag( array(
								'url'	=> esc_url( $single_data['gallery_image']['url'] ),
							) );
							echo '<a href="'.esc_url( $single_data['gallery_image']['url'] ).'" class="play-btn style3 popup-image"><i class="far fa-plus"></i></a>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			}  
		echo '</div>';
	}
}