{{ ucfunc("put_docready_start") }}

  var objStackingCards = jQuery("#{{uc_id}}");
  var objStackingCardsWrapper = objStackingCards.find('.ue_cards_wrapper');
  var objCards = objStackingCards.find('.ue_stacking_card_item');
  var classActive = "ue-active";
  var cardsStartPositions = getCardsStartPositions();
  var isClicked = false;

  //enable stiky position to calculate start position of all items
  enableStickyPos();

  {% if disable_section_id_source_js == "false" %}
	
	var objStackingCardWidget = new ueStackingCard();
  
    objStackingCardWidget.init("#{{uc_id}}");
   
  {% endif %}

  {% if scroll_related_animation == "true" %}
    
    var numCards = objCards.length; 

    gsap.registerPlugin(ScrollTrigger);

    objCards.each(function(index0) {
        const card = jQuery(this);
        const index = index0 + 1;
        const reverseIndex0 = numCards - index;

        // Scroll Related Styles
        gsap.to(card[0], {
            duration: 2,
            {% if scale_end_nounit is not empty %}scale: 1 - (-({{ scale_end_nounit / 10 }}) * reverseIndex0),{% endif %}
            rotate: {{rotation_end}} * reverseIndex0,
            {% if opacity_end_nounit is not empty %} opacity: {{opacity_end_nounit / 100}},{% endif %}
            {% if (blur_end_nounit is not empty) or (greyscale_end_nounit is not empty) %}
              filter:  {% if blur_end_nounit is not empty %}`blur(${reverseIndex0 * {{blur_end_nounit}}}px){% endif %} {% if greyscale_end_nounit is not empty %}grayscale(${reverseIndex0 * {{greyscale_end_nounit}}}%){% endif %}`,
           {% endif %}
          
            scrollTrigger: {
                trigger: objStackingCardsWrapper[0],
                start: `${(index0 / numCards) * 100}% top`,  // Start at each card’s section
                end: "bottom center", // End at next wrapper section
                scrub: true,
                onToggle: (self) => {
                  objStackingCards.trigger("ue_stacking_card_change")
                },
                onEnter: function(){          
                },
                onLeaveBack: function(){
                }
            },
        });
    });
                                                                                            
  {% endif %}//end scroll_related_animation  
    
  /**
  * enable sticky position
  */
  function enableStickyPos(){
    if(!objCards || objCards.length == 0)
    return(false);
      
    objCards.css("position", "sticky");
  }   
                                                                                            
  /**
  * gety cards init positions
  */
  function getCardsStartPositions(){
    var cardsStartPositionsArray = [];
     
    if(!objCards || objCards.length == 0)
    return(null);
      
    objCards.each(function(){
      var objCard = jQuery(this);
      var cardOffset = objCard.offset().top;
        
      cardsStartPositionsArray.push(cardOffset);
    });
      
    return(cardsStartPositionsArray);
  }                                                                                        
       
  /**
  * get active index
  */
  function getActiveIndex(){
    var index;
    var objActiveCard = objStackingCards.find("."+classActive);
      
    if(!objActiveCard || objActiveCard.legnth == 0)
      return(null);
      
    index = objActiveCard.index();
    return(index);
  }
  
  /**
  * scroll
  */
  function scrollTo(changePosition, time){
    jQuery('html, body').animate({
        scrollTop: changePosition
    }, time)
  }                                                                                        
    
  //vars
                                                                                                                           
  //events                                                                                        
  objStackingCards.on("uc_change", function(e){
    var activeIndex = getActiveIndex();
	
    if(activeIndex == null)
      return(true);
    
    if(isClicked == true)
      return(true);
    
    isClicked = true;
    
    setTimeout(function(){
    	isClicked = false;
    },200);    
     
    var activeOffset = cardsStartPositions[activeIndex];
      
    //scroll to selected item
    scrollTo(activeOffset, 100);
  });
   
  function initFancyBox(){
        if("{{enable_lightbox}}" == "false")
        return(false);

        //init fancybox only on non cloned items
        var fancyLink = objStackingCards.find(".ue-link");

        fancyLink.attr("data-fancybox", "gallery")

        fancyLink.fancybox({
            loop: true,
            arrows : false,
            backfocus: false,         
            touch: false,
            buttons: [
              "close"
            ],          
        });
  } 
   
 initFancyBox();  
    
  var objRemoteOptions = {
    	class_items:"ue_stacking_card_item",
    	class_active:"ue-active",
    	selector_item_trigger:null,
        add_set_active_code:true
  };
      
  {{ucfunc("put_remote_parent_js","objStackingCards","objRemoteOptions")}} 
             
{{ ucfunc("put_docready_end") }}