#{{uc_id}}.exp-wrapper {
  box-sizing: border-box;
  display: flex;
  flex-direction: row;
  justify-content: center;
  align-items: center;
}
#{{uc_id}}.exp-wrapper{
  width:100%;
}
#{{uc_id}}.exp-wrapper .ue_options {
  display: flex;
  align-items: center;
  flex-direction: row;
  justify-content: center;
  min-width: 200px;
  width:100%;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option {
  box-sizing: border-box;
  display: flex;
  position: relative;
  overflow: hidden;
  cursor: pointer;
  justify-content: center;
  background-repeat: no-repeat;
  background-size: cover;
}

#{{uc_id}}.exp-wrapper .ue_options .ue_option::after{
  content: "";
  position: absolute;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  transition: all .3s;
}
{% if css_filter_active == "none" %}
  #{{uc_id}}.exp-wrapper .ue_options .ue_option.active::after{
      backdrop-filter: none;
      -webkit-backdrop-filter: none;
  }
{% endif %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option.active {
  flex-grow: 10000;
}

#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) {
  justify-content: center;
}
{% if background_overlay == "true" %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option .ue_shadow {
  position: absolute;
  bottom: 0px;
  left: 0px;
  right: 0px;
  height: 100%;
  z-index:1;
  transition: {{transition_duration}}ms;
}
{% endif %}
#{{uc_id}}.exp-wrapper .ue_option:not(.active) .ue_label {
  align-items: center;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option .ue_label {
  display: flex;
  z-index:2;
  {% if rotation_animation == "true" %}
  	transition: 0.5s cubic-bezier(0.05, 0.61, 0.41, 0.95);
  {% endif %}
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option.active .ue_label{
  animation-name: sub-content-fade;
}
@keyframes sub-content-fade{
  0%   {opacity:0;}
  80%  {opacity:0;}
  100% {opacity:1;}
}
{% if enable_link == "true" %}
 #{{uc_id}}.exp-wrapper .ue_content_link{
     width:100%
  }
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_content_link{
  pointer-events: none;
}
#{{uc_id}}.exp-wrapper .ue_content_link.ue_content_link--hover-mode{
  position: absolute;
  width: 100%;
  height: 100%;
}
{% endif %}

{% if show_button == "true" %}
#{{uc_id}}.exp-wrapper .ue_option:not(.active) .ue_button {
  display:none;
  opacity: 0;
  text-align:center;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option.active .ue_button {
  opacity: 1;
  text-align:center;
  flex-shrink: 0;
  width: auto;
  transition:250ms;
  z-index:2;
}
{% endif %}

{% if (show_title == "true") or (show_subitle == "true") %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option.active .ue_label .ue_info > div {
  left: 0px;
  width:100%;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info > div:not(.ue_icon, .ue_main) {
  left: 0px;
  opacity: 0;
  width: 0px;
  height: 0px;
  transition: width 0ms;
}

#{{uc_id}}.exp-wrapper .ue_options .ue_option .ue_label .ue_info > div {
  position: relative;
  {% if rotation_animation == "true" %}
  	transition: 0.5s cubic-bezier(0.05, 0.61, 0.41, 0.95), opacity 0.5s ease-out;
  {% endif %}
}
#{{uc_id}}.exp-wrapper  .ue_options .ue_option .ue_label .ue_info {
  display: flex;
  align-items: center;
  justify-content: center;
}
{% endif %}

{% if show_vertical_title == "true" %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info {
  margin-left: 0px!important;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info .ue_main {
  opacity: 1;
  width: auto;
  height: auto;
  writing-mode: vertical-rl;
  text-orientation: mixed;
  text-decoration: none;
}

#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_sub {
  height:0;
  margin-top: 0px;
}
{% endif %}

{% if show_graphic_element == "true" %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option .ue_label .ue_icon {
  display: flex;
  flex-shrink: 0;
  flex-direction: row;
  justify-content: center;
  align-items: center;
  overflow: hidden;
  transition: 0.5s;
}
{% endif %}

@media screen and (max-width: {{responsive_breakpoint}}px) {

#{{uc_id}}.exp-wrapper .ue_options .ue_option::after{
  backdrop-filter: none;
  -webkit-backdrop-filter: none;
}
#{{uc_id}}.exp-wrapper .ue_options .active.ue_option::after{
  backdrop-filter: none;
  -webkit-backdrop-filter: none;
}
#{{uc_id}}.exp-wrapper .ue_options {
  display: grid;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option{
    width: 100%;
}
  
{% if collapsible_on_breakpoint == "false" %}
{% if show_vertical_title == "true" %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info {
  margin-left: 0px!important;
}

#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info .ue_main {
  opacity: 1;
  width: auto;
  height: auto;
  writing-mode: horizontal-tb;
  text-orientation: mixed;
  text-decoration: none;
  transform: rotate(0deg);
}
{% endif %}
  
{% if enable_link == "true" %}
  #{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_content_link{
    pointer-events: auto;
  } 
{% endif %}
  
{% if show_button == "true" %}
  #{{uc_id}}.exp-wrapper .ue_option:not(.active) .ue_button {
    text-align:center;
    display: inline-block;
    opacity: 1;
  }
{% endif %}

{% if (show_title == "true") or (show_subitle == "true") %}
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info > div {
  opacity:1;
  width:100%;
  height:auto;
}
#{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_sub {
  height:auto;
}
{% endif %} 
{% endif %} 
  
  
{% if collapsible_on_breakpoint == "true" %}
  #{{uc_id}} .ue_option.active{
    height:{{active_card_height}};
  }
  #{{uc_id}} .ue_option{
    height:{{inactive_card_height}};
  }
  #{{uc_id}}.exp-wrapper .ue_options .ue_option:not(.active) .ue_label .ue_info .ue_main {
    writing-mode: horizontal-tb;
  }
{% endif %} 
  
}