#{{uc_id}}.uc-ajax-search-wrapper{
	
    position:relative;
    display:flex;
    width:100%;
}


#{{uc_id}} .uc-ajax-search__suggested, #{{uc_id}} .uc-ajax-search__suggested-wrapper
{
  display:flex;
  flex-wrap: wrap;
  align-items:center;
}

#{{uc_id}} .uc-ajax-search__title
{
  display:block;
}
#{{uc_id}} .uc-ajax-search-wrapper-inside
{
  width:100%;
}

#{{uc_id}}.uc-ajax-search-wrapper span{
}

#{{uc_id}}.uc-ajax-search-wrapper input{
  width:100%;
}


#{{uc_id}} .uc-ajax-search__input-wrapper-inner
{
  position:relative;
  flex-grow:1;
}

.ue-grid-item-category a
{
  display:inline-block;
  font-size:10px;
  
}

#{{uc_id}} .uc-ajax-search__items{
	position:absolute;
    left:0px;
    {% if width_type == "full" %}
    width:100%;
    {% endif %}
  	z-index:999999;
    overflow:hidden;
}

#{{uc_id}} .uc-search-item{  
	position: relative;
}

#{{uc_id}} .ue-grid-item-category a{
	position: relative;
  	z-index: 1;
}

#{{uc_id}} .uc-search-item__link{
	display:flex;
    align-items:center;
    gap:10px;
}

{% if show_categories != "false" %}
#{{uc_id}} .uc-search-item__link-absolute{
  	position: absolute;
  	width: 100%;
  	height: 100%;
  	top: 0;
  	left: 0;   
}
{% endif %}

#{{uc_id}} .uc-search-item__link-title{
  display:block;
}

#{{uc_id}} .uc-search-item__link-title b.uc-capitalized,
#{{uc_id}} .uc-search-item__link-title:not(b.uc-capitalized)::first-letter {
  text-transform: none;
}

#{{uc_id}} .uc-search-item__link-image{
    display:block;
    flex-grow:0;
    flex-shrink:0;
} 

#{{uc_id}} .uc-ajax-search__input-wrapper{
	position:relative;
    display:flex;
    align-items:center;
    justify-content:center;
}

#{{uc_id}} .uc-search-item{
	transition: background-color .3s;
}

#{{uc_id}} .uc-search-item.uc-selected{
	background-color: #ccc;
}


#{{uc_id}} .uc-pagination-list{
	display: flex;
  	flex-wrap: nowrap;
  	width: 100%;
  	transition: transform .3s;
}

#{{uc_id}} .uc-pagination-list-inner{
	flex: 0 0 100%;
  	max-width: 100%;
}

#{{uc_id}} .uc-pagination-header{
	display: flex;
  	justify-content: space-between;
  	align-items: center;
  	direction: ltr;
}

#{{uc_id}} .uc-ajax-search-pages{
	display: flex;
  	gap: 5px;
}


#{{uc_id}} .uc-ajax-search-navigation-panel{
	display: flex;
  	gap: 15px;
  	justify-content: space-between;
}

#{{uc_id}} .uc-ajax-arrows{
	display: flex;
  	justify-content: space-between;
  	gap: 10px;
  	cursor: pointer;
}

#{{uc_id}} .uc-ajax-arrows .uc-inactive{
	opacity: .5;
}

#{{uc_id}} .uc-ajax-arrow-left{
	position: relative;
}

#{{uc_id}} .uc-ajax-arrow-left::before{
	font-family: "Font Awesome 5 Free";
    content: "\{{left_font_awesome|raw}}";
    font-weight: 900;
    line-height:1em;
  	display: inline-flex;
}

#{{uc_id}} .uc-ajax-arrow-right::before{
	font-family: "Font Awesome 5 Free";
    content: "\{{right_font_awesome|raw}}";
    font-weight: 900;
    line-height:1em;
  	display: inline-flex;
}

#{{uc_id}} .uc-ajax-search__btn
{
  display:flex;
  align-items:center;
  justify-content:center;
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .uc-ajax-search__btn.uc-inactive{
	cursor: default;
  	opacity: 0.7;
	pointer-events: none;
}

#{{uc_id}} .uc-ajax-search__btn_icon
{
  line-height:1em;
}

#{{uc_id}} .uc-ajax-search__btn svg
{
  height:1em;
  width:1em;
}

#{{uc_id}}.uc-loading .uc-ajax-search__spinner__loader-wrapper{
	display:flex !important;
}

#{{uc_id}} .uc-ajax-search__error{
	color:red;
    padding-top:15px;
}

#{{uc_id}} .uc-ajax-search__spinner__loader-wrapper{
  position:absolute;
  top:50%;
  transform:translateY(-50%);
  height: 100%;
  justify-content: center;
  align-items: center;
  inset-inline-end: 15px;
}

#{{uc_id}} .uc-ajax-search__spinner {
  animation: ajaxsearchrotate 2s linear infinite;
  z-index: 2;
  width: 25px;
  height: 25px;
}

#{{uc_id}} .uc-ajax-search__spinner-path {
  stroke-linecap: round;
  animation: ajaxsearchdash 1.5s ease-in-out infinite;
}

#{{uc_id}} .uc-pagination-list-inner
{
  display:grid;
}

#{{uc_id}} ::-webkit-input-placeholder { /* Edge */
  color: {{search_placeholder_color}};
}

#{{uc_id}} :-ms-input-placeholder { /* Internet Explorer 10-11 */
  color: {{search_placeholder_color}};
}

#{{uc_id}} ::placeholder {
  color: {{search_placeholder_color}};
}

#{{uc_id}} .uc-ajax-search__input.uc-active{
 caret-color: unset;
}

#{{uc_id}} .uc-ajax-search__input{
 caret-color: transparent;
}

#{{uc_id}} .uc-highlight{
 font-weight: 700;
}

@keyframes ajaxsearchrotate {
  100% {
    transform: rotate(360deg);
  }
}

@keyframes ajaxsearchdash {
  0% {
    stroke-dasharray: 1, 150;
    stroke-dashoffset: 0;
  }
  50% {
    stroke-dasharray: 90, 150;
    stroke-dashoffset: -35;
  }
  100% {
    stroke-dasharray: 90, 150;
    stroke-dashoffset: -124;
  }
}