#{{uc_id}} .ue-glowing-widget {
  max-width: 100%;
}

#{{uc_id}} .ue-glowing-cards-container {
  display: flex;
  justify-content: center;
  flex-wrap: wrap;
}

#{{uc_id}} .ue-glowing-card-wrapper {
  position: relative;
  width: 100%;
}

#{{uc_id}} .ue-glowing-border-container {
  position: absolute;
  width: 100%;
  height: 100%;
  overflow: hidden;
}

#{{uc_id}} .ue-glowing-card {
  position: relative;
  margin: 2px;
  display: flex;
  align-items: center;
  cursor: pointer;
  z-index: 2;
  overflow: hidden;
}

#{{uc_id}} .ue-glowing-card-content {
  color: white;
  position: relative;
  z-index: 3;
}

#{{uc_id}} .ue-glowing-icon-wrapper{
  display: flex;
  overflow:hidden;
}

#{{uc_id}} .ue-glowing-card-icon {
  display:grid;
  place-content:center;
  overflow:hidden;
}

/* The cursor glow for inside the card */
#{{uc_id}} .ue-glowing-cursor-glow {
  position: absolute;
  width: 400px;
  height: 400px;
  background: radial-gradient(
  circle,
  {{glow_color}}{{cursor_opacity}} 0%,
  transparent 70%
  );
  border-radius: 50%;
  pointer-events: none;
  z-index: 2;
  opacity: 0;
  transform: translate(-50%, -50%);
}

/* The cursor glow for the border */
#{{uc_id}} .ue-glowing-border-glow {
  position: absolute;
  width: 200px;
  height: 200px;
  background: radial-gradient(
  circle,
  rgba(255, 255, 255, 1) 0%,
  rgba(255, 255, 255, 0.7) 30%,
  rgba(255, 255, 255, 0.3) 60%,
  transparent 80%
  );
  border-radius: 50%;
  pointer-events: none;
  z-index: 1;
  opacity: 0;
  mix-blend-mode: screen;
  transform: translate(-50%, -50%);
}

/* Card specific border glow colors */
#{{uc_id}} .ue-glowing-card-1 .ue-glowing-border-glow {
  background: radial-gradient(
  circle,
  {{border_glow_color_1}} 0%,
  {{border_glow_color_2}}80 30%,
  {{border_glow_color_3}}40 60%,
  transparent 80%
  );
}

#{{uc_id}} .ue-button-wrapper{
  display:flex;
}

{% if show_badge == "true" %}
#{{uc_id}} .ue-glowing-card-badge {
  position: absolute;
  top: 24px;
  {% if badge_placement == "right" %}right: -70px;transform: rotate(45deg);{% endif %}	
  {% if badge_placement == "left" %}left: -70px;transform: rotate(-45deg);{% endif %}
  width: 200px;
  text-align: center;
  box-sizing: border-box;
  z-index:2;
}

.ue-glowing-card-badge{
  font-size:10px;
  line-height:1em;
}
{% endif %}